Disallows usage of the `outputs` metadata property. See more at https://angular.io/styleguide#style-05-12

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```ts
@Component({
  outputs: [
  ~~~~~~~~~~
    'id: foo'
  ],
  ~
  selector: 'app-test'
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  outputs: [
  ~~~~~~~~~~
    'id: foo'
  ],
  ~
  selector: 'app-test'
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Component({
  outputs,
  ~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  outputs: [],
  ~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
const test = [];
@Component({
  'outputs': test,
  ~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
@Directive({
  ['outputs']: undefined,
  ~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

<br>

---

<br>

#### ❌ Invalid Code

```ts
function outputs() {
  return [];
}

@Component({
  [`outputs`]: outputs(),
  ~~~~~~~~~~~~~~~~~~~~~~
})
class Test {}
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```ts
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component()
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const options = {};
@Component(options)
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Directive({
  selector: 'app-test',
  template: 'Hello'
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'app-test',
  queries: {},
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
const outputs = 'providers';
@Directive({
  [outputs]: [],
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@NgModule({
  bootstrap: [Foo]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'foo',
  hostDirectives: [{
    directive: CdkMenuItem,
    outputs: ['cdkMenuItemTriggered: triggered'],
  }]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'foo',
  'hostDirectives': [{
    directive: CdkMenuItem,
    outputs: ['cdkMenuItemTriggered: triggered'],
  }]
})
class Test {}
```

<br>

---

<br>

#### ✅ Valid Code

```ts
@Component({
  selector: 'foo',
  ['hostDirectives']: [{
    directive: CdkMenuItem,
    outputs: ['cdkMenuItemTriggered: triggered'],
  }]
})
class Test {}
```

</details>
