Disallows the use of inline styles in HTML templates

- Type: suggestion

<br>

## Usage Examples

> The following examples are generated automatically from the actual unit tests within the plugin, so you can be assured that their behavior is accurate based on the current commit.

<br>

<details>
<summary>❌ - Toggle examples of <strong>incorrect</strong> code for this rule</summary>

<br>

#### ❌ Invalid Code

```html
<ng-template>
  <div>
    <img style="position: relative;">
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  </div>
</ng-template>
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<object style="padding: 30px;"></object>
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<area style="padding: 30px;" />
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input style="color: red;">
~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [attr.style]="'padding: 10px;'">
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [style.background-color]="'#fff'">
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [style]="'border: 1px solid black;'" [ngStyle]="{ 'padding': '10px' }" [style.background-color]="'#fff'">
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [ngStyle]="'background-color: #fff'">
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [style]="'border: 1px solid black;'">
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

<br>

---

<br>

#### ❌ Invalid Code

```html
<input [ngStyle]="{ 'padding': '10px' }" [style]="'border: 1px solid black;'">
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

</details>

<br>

---

<br>

<details>
<summary>✅ - Toggle examples of <strong>correct</strong> code for this rule</summary>

<br>

#### ✅ Valid Code

```html
<img alt="Foo eating a sandwich.">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img src="foo" [attr.alt]="altText">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img src="foo" [attr.alt]="'Alt Text'">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<img src="foo" alt="">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<object aria-label="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<object aria-labelledby="id1">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<object>Meaningful description</object>
```

<br>

---

<br>

#### ✅ Valid Code

```html
<object title="An object">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<area aria-label="foo" />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<area aria-labelledby="id1" />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<area alt="This is descriptive!" />
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="text">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="image" alt="This is descriptive!">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="image" aria-label="foo">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input type="image" aria-labelledby="id1">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input [ngStyle]="{ 'background-color': '#fff' }">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input [style.backgroundColor]="'#fff'">
```

<br>

---

<br>

#### ✅ Valid Code

```html
<input [ngStyle]="{ 'background-color': 'red' }" [style.background-color]="'#fff'">
```

</details>
