Enforce event handler naming conventions in JSX.


Ensures that any component or prop methods used to handle events are correctly prefixed.

## Rule Details

Examples of **incorrect** code for this rule:

```jsx
<MyComponent handleChange={this.handleChange} />
```

```jsx
<MyComponent onChange={this.componentChanged} />
```

Examples of **correct** code for this rule:

```jsx
<MyComponent onChange={this.handleChange} />
```

```jsx
<MyComponent onChange={this.props.onFoo} />
```

## When Not To Use It

If you are not using JSX, or if you don't want to enforce specific naming conventions for event handlers.
