Enforce maximum of props on a single line in JSX.




Limiting the maximum of props on a single line can improve readability.

Note: The fixer does not include indentation. Please rerun lint to correct those errors.

## Rule Details

This rule checks all JSX elements and verifies that the number of props per line do not exceed the maximum allowed. Props are considered to be in a new line if there is a line break between the start of the prop and the end of the previous prop. A spread attribute counts as one prop. This rule is off by default and when on the default maximum of props on one line is `1`.

Examples of **incorrect** code for this rule:

```jsx
<Hello lastName="Smith" firstName="John" />;

<Hello foo={{
  bar
}} baz />;
```

Examples of **correct** code for this rule:

```jsx
<Hello
  firstName="John"
  lastName="Smith"
/>;

<Hello
  {...this.props}
  firstName="John"
  lastName="Smith"
/>;
```

## When Not To Use It

If you are not using JSX then you can disable this rule.
