Disallow extra closing tags for components without children.




Components without children can be self-closed to avoid unnecessary extra closing tag.

## Rule Details

Examples of **incorrect** code for this rule:

```jsx
var HelloJohn = <Hello name="John"></Hello>;

var HelloJohnCompound = <Hello.Compound name="John"></Hello.Compound>;
```

Examples of **correct** code for this rule:

```jsx
var contentContainer = <div className="content"></div>;

var intentionalSpace = <div>{' '}</div>;

var HelloJohn = <Hello name="John" />;

var HelloJohnCompound = <Hello.Compound name="John" />;

var Profile = <Hello name="John"><img src="picture.png" /></Hello>;

var ProfileCompound = <Hello.Compound name="John"><img src="picture.png" /></Hello.Compound>;

var HelloSpace = <Hello>{' '}</Hello>;
```
