Line comments can be positioned above or beside code. This rule helps teams maintain a consistent style.

```js
// above comment
var foo = "bar";  // beside comment
```

## Rule Details

This rule enforces consistent position of line comments. Block comments are not affected by this rule. By default, this rule ignores comments starting with the following words: `eslint`, `jshint`, `jslint`, `istanbul`, `global`, `exported`, `jscs`, `falls through`.

## When Not To Use It

If you aren't concerned about having different line comment styles, then you can turn off this rule.

## Compatibility

**JSCS**: [validateCommentPosition](https://jscs-dev.github.io/rule/validateCommentPosition)
