### SCS0004 - Certificate Validation Disabled 

Certificate Validation has been disabled. The communication could be intercepted.

#### Risk

Disabling certificate validation is often used to connect easily to a host that is not signed by a root [certificate authority](http://en.wikipedia.org/wiki/Certificate%5Fauthority). As a consequence, this is vulnerable to [Man-in-the-middle attacks](http://en.wikipedia.org/wiki/Man-in-the-middle%5Fattack) since the client will trust any certificate.

#### Vulnerable Code

```cs
ServicePointManager.ServerCertificateValidationCallback += (sender, cert, chain, sslPolicyErrors) => true;

```

#### Solution

* Make sure the validation is disabled only in testing environment or
* Use [certificate pinning](https://www.owasp.org/index.php/Certificate%5Fand%5FPublic%5FKey%5FPinning) for development or
* Use properly signed certificates for development

```cs
#if DEBUG
    ServicePointManager.ServerCertificateValidationCallback += (sender, cert, chain, sslPolicyErrors) => true;
#endif

```

#### References

[CWE-295: Improper Certificate Validation](https://cwe.mitre.org/data/definitions/295.html)  
[WASC-04: Insufficient Transport Layer Protection](http://projects.webappsec.org/w/page/13246945/Insufficient%20Transport%20Layer%20Protection)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)