<h2>Why is this an issue?</h2>
<p>When an exception is logged and rethrown, the upstream code may not be aware that the exception has already been logged. As a result, the same
exception gets logged multiple times, making it difficult to identify the root cause of the issue. This can be particularly problematic in
multi-threaded applications where messages from other threads can be interwoven with the repeated log entries.</p>
<h3>Exceptions</h3>
<p>This rule will not generate issues if, within the catch block, one of the following conditions are met:</p>
<ul>
  <li> The logs generated within the catch block do not contain any references to the exception being caught. </li>
  <li> The exception being thrown from the catch block is not the same exception that is being caught. </li>
</ul>
<h2>How to fix it</h2>
<p>To address this issue, it is recommended to modify the code to log exceptions only when they are handled locally. In all other cases, simply
rethrow the exception and allow the higher-level layers of the application to handle the logging and appropriate actions.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
try {}
catch (Exception ex)
{
  logger.LogError(ex.Message);
  throw;
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
try {}
catch (Exception ex)
{
  logger.LogError(ex.Message);
  // Handle exception
}
</pre>
<p>or</p>
<pre>
try {}
catch (Exception ex)
{
  // ...
  throw;
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a
  href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/exception-handling-statements">Exception-handling statements</a>
  </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://rolf-engelhard.de/2013/04/logging-anti-patterns-part-ii/">Rolf Engelhard - Logging anti-patterns</a> </li>
</ul>

