<h2>Why is this an issue?</h2>
<p><a href="https://learn.microsoft.com/en-us/dotnet/api/system.double.nan">double.NaN</a> and <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.single.nan">float.NaN</a> are not equal to anything, not even themselves.</p>
<p>When anything is compared with <code>NaN</code> using one of the <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/comparison-operators">comparison operators</a> <code>&gt;</code>,
<code>&gt;=</code>, <code>&lt;</code>, <code>⇐</code> or the <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators#equality-operator-">equality operator</a>
<code>==</code>, the result will always be <code>false</code>. In contrast, when anything is compared with <code>NaN</code> using the <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/equality-operators#inequality-operator-">inequality operator</a>
<code>!=</code>, the result will always be <code>true</code>.</p>
<p>Instead, the best way to see whether a variable is equal to <code>NaN</code> is to use the <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.single.isnan">float.IsNaN</a> and <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.double.isnan">double.IsNaN</a> methods, which work as expected.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
var a = double.NaN;

if (a == double.NaN) // Noncompliant: always false
{
  Console.WriteLine("a is not a number");
}
if (a != double.NaN)  // Noncompliant: always true
{
  Console.WriteLine("a is not NaN");
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
var a = double.NaN;

if (double.IsNaN(a))
{
  Console.WriteLine("a is not a number");
}
if (!double.IsNaN(a))
{
  Console.WriteLine("a is not NaN");
}
</pre>

