<h2>Why is this an issue?</h2>
<p>Jump statements, such as <code>return</code>, <code>yield break</code>, <code>goto</code>, and <code>continue</code> let you change the default
flow of program execution, but jump statements that direct the control flow to the original direction are just a waste of keystrokes.</p>
<h3>Noncompliant code example</h3>
<pre>
void Foo()
{
  goto A; // Noncompliant
  A:
  while (condition1)
  {
    if (condition2)
    {
      continue; // Noncompliant
    }
    else
    {
      DoTheThing();
    }
  }
  return; // Noncompliant; this is a void method
}
</pre>
<h3>Compliant solution</h3>
<pre>
void Foo()
{
  while (condition1)
  {
    if (!condition2)
    {
      DoTheThing();
    }
  }
}
</pre>

