<h2>Why is this an issue?</h2>
<p>Using the <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/readonly"><code>readonly</code> keyword</a> on a
field means it can’t be changed after initialization. However, that’s only partly true when applied to collections or arrays. The
<code>readonly</code> keyword enforces that another instance can’t be assigned to the field, but it cannot keep the contents from being updated. In
practice, the field value can be changed, and the use of <code>readonly</code> on such a field is misleading, and you’re likely not getting the
behavior you expect.</p>
<p>This rule raises an issue when a non-private, <code>readonly</code> field is an array or collection.</p>
<h2>How to fix it</h2>
<p>To fix this, you should either use an <a href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.immutable">immutable</a> or <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.collections.frozen">frozen</a> collection or remove the <code>readonly</code> modifier to
clarify the behavior.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
public class MyClass
{
  public readonly string[] strings1;  // Noncompliant
  public readonly string[] strings2;  // Noncompliant
  public readonly string[] strings3;  // Noncompliant
  // ...
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
public class MyClass
{
  public string[] strings1;                         // Compliant: remove readonly modifier
  public readonly ImmutableArray&lt;string&gt; strings;   // Compliant: use an Immutable collection
  private readonly string[] strings;                // Compliant: reduced accessibility to private

  // ...
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/readonly">readonly (C# Reference)</a>
  </li>
</ul>

