<h2>Why is this an issue?</h2>
<p>Fields marked with <code>System.Runtime.Serialization.OptionalFieldAttribute</code> are serialized just like any other field. But such fields are
ignored on deserialization, and retain the default values associated with their types. Therefore, deserialization event handlers should be declared to
set such fields during the deserialization process.</p>
<p>This rule raises when at least one field with the <code>System.Runtime.Serialization.OptionalFieldAttribute</code> attribute is declared but one
(or both) of the following event handlers <code>System.Runtime.Serialization.OnDeserializingAttribute</code> or
<code>System.Runtime.Serialization.OnDeserializedAttribute</code> are not present.</p>
<h3>Noncompliant code example</h3>
<pre>
[Serializable]
public class Foo
{
    [OptionalField(VersionAdded = 2)]
    int optionalField = 5;
}
</pre>
<h3>Compliant solution</h3>
<pre>
[Serializable]
public class Foo
{
    [OptionalField(VersionAdded = 2)]
    int optionalField = 5;

    [OnDeserializing]
    void OnDeserializing(StreamingContext context)
    {
	    optionalField = 5;
    }

    [OnDeserialized]
    void OnDeserialized(StreamingContext context)
    {
        // Set optionalField if dependent on other deserialized values.
    }
}
</pre>

