﻿## SA1014

<table>
<tr>
  <td>TypeName</td>
  <td>SA1014OpeningGenericBracketsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1014</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

An opening generic bracket within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around an opening generic bracket is not correct.

An opening generic bracket should never be preceded or followed by whitespace, unless the bracket is the first or last character on the line.

## How to fix violations

To fix a violation of this rule, ensure that there is no whitespace on either side of the opening generic bracket.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1014:OpeningGenericBracketsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1014 // OpeningGenericBracketsMustBeSpacedCorrectly
#pragma warning restore SA1014 // OpeningGenericBracketsMustBeSpacedCorrectly
```
