# SA1102

<table>
<tr>
  <td>Title</td>
  <td>Query clause should follow previous clause</td>
</tr>
<tr>
  <td>TypeName</td>
  <td>SA110xQueryClauses</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1102</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A C# query clause does not begin on the same line as the previous clause, or on the next line.

## Rule description

A violation of this rule occurs when a clause within a query expression does not begin on the same line as the previous clause, or on the line after the query clause. For example:
```c#
    object x = select a in b

        from c;
```

The query clause can correctly be written as:
```c#
    object x = select a in b from c;
```
or:
```c#
    object x =
        select a
        in b
        from c;
```
 
## How to fix violations

To fix a violation of this rule, ensure that each clause in the query expression begins on the same line as the previous clause, or on the following line.

## How to suppress violations

```c#
#pragma warning disable SA1102 // Query clause should follow previous clause
    object x = select a in b

        from c;
#pragma warning restore SA1102 // Query clause should follow previous clause
```
