﻿## SA1114

<table>
<tr>
  <td>TypeName</td>
  <td>SA1114ParameterListMustFollowDeclaration</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1114</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The start of the parameter list for a method or indexer call or declaration does not begin on the same line as the opening bracket, or on the line after the opening bracket.

## Rule description

A violation of this rule occurs when there are one or more blank lines between the opening bracket and the start of the parameter list. For example:

```csharp
public string JoinName(

    string first, string last)
{
}
```

The parameter list should begin on the same line as the opening bracket, or on the next line. For example:

```csharp
public string JoinName(string first, string last)
{
}

public string JoinName(
    string first, string last)
{
}
```

## How to fix violations

To fix a violation of this rule, ensure that the parameter list begins on the same line as the opening bracket, or on the next line.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1114:ParameterListMustFollowDeclaration", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1114 // ParameterListMustFollowDeclaration
#pragma warning restore SA1114 // ParameterListMustFollowDeclaration
```
