﻿## SA1312

<table>
<tr>
  <td>TypeName</td>
  <td>SA1312VariableNamesMustBeginWithLowerCaseLetter</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1312</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The name of a variable in C# does not begin with a lower-case letter.

## Rule description

A violation of this rule occurs when the name of a variable does not begin with a lower-case letter.

If the variable name is intended to match the name of an item associated with Win32 or COM, and thus needs to begin with
an upper-case letter, place the variable within a special `NativeMethods` class. A `NativeMethods` class is any class
which contains a name ending in `NativeMethods`, and is intended as a placeholder for Win32 or COM wrappers. StyleCop
will ignore this violation if the item is placed within a `NativeMethods` class.

## How to fix violations

To fix a violation of this rule, change the name of the variable so that it begins with a lower-case letter, or place
the item within a `NativeMethods` class if appropriate.

## How to suppress violations

```csharp
#pragma warning disable SA1312 // VariableNamesMustBeginWithLowerCaseLetter
int Variable = 3;
#pragma warning restore SA1312 // VariableNamesMustBeginWithLowerCaseLetter
```
