﻿## SA1509

<table>
<tr>
  <td>TypeName</td>
  <td>SA1509OpeningBracesMustNotBePrecededByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1509</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

An opening brace within a C# element, statement, or expression is preceded by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines
in other situations. This results in a consistent visual pattern across the code, which can improve recognition and
readability of unfamiliar code.

In general, a violation of this rule occurs when an opening brace is preceded by a blank line. For example, the
following above would generate two instances of this violation, since there are two places where opening braces are
preceded by blank lines.

```csharp
public bool Enabled

{
    get

    {
        return this.enabled;
    }
}
```

An exception to this rule occurs when the opening brace is preceded by a closing brace. When this occurs, a blank line
will be required by [SA1513](SA1513.md). The following example shows correct use of blank lines:

```csharp
public bool Enabled
{
    get
    {
        {
        }

        {
            return this.enabled;
        }
    }
}
```

## How to fix violations

To fix a violation of this rule, remove the blank line preceding the opening brace.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1509:OpeningBracesMustNotBePrecededByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1509 // OpeningBracesMustNotBePrecededByBlankLine
#pragma warning restore SA1509 // OpeningBracesMustNotBePrecededByBlankLine
```
