﻿# SA1519

<table>
<tr>
  <td>TypeName</td>
  <td>SA1519BracesMustNotBeOmittedFromMultiLineChildStatement</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1519</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The opening and closing braces for a multi-line C# statement have been omitted.

## Rule description

A violation of this rule occurs when the opening and closing braces for a multi-line statement have been
omitted. In C#, some types of statements may optionally include braces. Examples include `if`, `while`, and
`for` statements. For example, an `if`-statement may be written without braces:

```csharp
if (true)
    return
        this.value;
```

Although this is legal in C#, StyleCop requires the braces to be present when the statement spans multiple
lines, to increase the readability and maintainability of the code.

## How to fix violations

To fix a violation of this rule, the violating statement will be converted to a block statement.

## How to suppress violations

```csharp
if (true)
#pragma warning disable SA1519 // Braces should not be omitted from multi-line child statement
    return
        this.value;
#pragma warning restore SA1519 // Braces should not be omitted from multi-line child statement
```
