﻿## SA1609

<table>
<tr>
  <td>TypeName</td>
  <td>SA1609PropertyDocumentationMustHaveValue</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1609</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The Xml header documentation for a C# property does not contain a `<value>` tag.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

The documentation for properties may include a `<value>` tag, which describes the value held by the property.

A violation of this rule occurs when the `<value>` tag for a property is missing.

## How to fix violations

To fix a violation of this rule, add and fill-in a `<value>` tag within the documentation header for the property.

The following example shows a property which contains a `<value>` tag within its documentation header.

```csharp
/// <summary>
/// Gets the name of the customer. 
/// </summary>
/// <value>The name of the customer.</value>
public bool Name
{
    get { return this.name; }
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1609:PropertyDocumentationMustHaveValue", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1609 // PropertyDocumentationMustHaveValue
#pragma warning restore SA1609 // PropertyDocumentationMustHaveValue
```
