<h2>Why is this an issue?</h2>
<p>Early classes of the Java API, such as <code>Vector</code>, <code>Hashtable</code> and <code>StringBuffer</code>, were synchronized to make them
thread-safe. However, synchronization has a significant negative impact on performance, even when using these collections from a single thread.</p>
<p>It is often best to use their non-synchronized counterparts:</p>
<ul>
  <li> <code>ArrayList</code> or <code>LinkedList</code> instead of <code>Vector</code> </li>
  <li> <code>Deque</code> instead of <code>Stack</code> </li>
  <li> <code>HashMap</code> instead of <code>Hashtable</code> </li>
  <li> <code>StringBuilder</code> instead of <code>StringBuffer</code> </li>
</ul>
<p>Even when used in synchronized contexts, you should think twice before using their synchronized counterparts, since their usage can be costly. If
you are confident the usage is legitimate, you can safely ignore this warning.</p>
<h3>Noncompliant code example</h3>

```java
Vector<Cat> cats = new Vector<>();
```
<h3>Compliant solution</h3>

```java
ArrayList<Cat> cats = new ArrayList<>();
```
<h3>Exceptions</h3>
<p>Usage of these synchronized classes is ignored in the signatures of overriding methods.</p>

```java
@Override
public Vector getCats() {...} // Compliant
```