<h2>Why is this an issue?</h2>
<p>Shared naming conventions make it possible for a team to collaborate efficiently. Following the established convention of single-letter type
parameter names helps users and maintainers of your code quickly see the difference between a type parameter and a poorly named class.</p>
<p>This rule check that all type parameter names match a provided regular expression. The following code snippets use the default regular
expression.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass<TYPE> { // Noncompliant
  <TYPE> void method(TYPE t) { // Noncompliant
  }
}
```
<h3>Compliant solution</h3>

```java
public class MyClass<T> {
  <T> void method(T t) {
  }
}
```