<h2>Why is this an issue?</h2>
<p>Shared coding conventions allow teams to collaborate effectively. While types for lambda arguments are optional, specifying them anyway makes the
code clearer and easier to read.</p>
<h3>Noncompliant code example</h3>

```java
Arrays.sort(rosterAsArray,
    (a, b) -> {  // Noncompliant
        return a.getBirthday().compareTo(b.getBirthday());
    }
);
```
<h3>Compliant solution</h3>

```java
Arrays.sort(rosterAsArray,
    (Person a, Person b) -> {
        return a.getBirthday().compareTo(b.getBirthday());
    }
);
```
<h3>Exceptions</h3>
<p>When the lambda has one or two parameters and does not have a block this rule will not fire up an issue as things are considered more readable in
those cases.</p>

```java
stream.map((a, b) -> a.length); // compliant
```