<h2>Why is this an issue?</h2>
<p>The <code>IllegalMonitorStateException</code> is an exception that occurs when a thread tries to perform an operation on an object’s monitor that
it does not own. This exception is typically thrown when a method like <code>wait()</code>, <code>notify()</code>, or <code>notifyAll()</code> is
called outside a synchronized block or method.</p>
<p><code>IllegalMonitorStateException</code> is specifically designed to be an unchecked exception to point out a programming mistake. This exception
serves as a reminder for developers to rectify their code by correctly acquiring and releasing locks using synchronized blocks or methods. It also
emphasizes the importance of calling monitor-related methods on the appropriate objects to ensure proper synchronization.</p>
<p>Catching and handling this exception can mask underlying synchronization issues and lead to unpredictable behavior.</p>
<h3>Noncompliant code example</h3>

```java
public void doSomething() {
  try {
    anObject.notify();
  } catch(IllegalMonitorStateException e) { // Noncompliant
  }
}
```
<h3>Compliant solution</h3>

```java
public void doSomething() {
  synchronized(anObject) {
    anObject.notify();
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/lang/IllegalMonitorStateException.html">Oracle Java SE -
  IllegalMonitorStateException</a> </li>
</ul>