<h2>Why is this an issue?</h2>
<p>There are various <code>String</code> operations that take one or more character indexes as arguments and return a portion of the original string.
Indexing in this context is zero-based, meaning that the first character’s index is <code>0</code>. As a result, given a string <code>myString</code>,
its last character is at index <code>myString.length() - 1</code>.</p>
<p>The <code>String</code> operation methods throw a <code>StringIndexOutOfBoundsException</code> when one of their index argument is smaller than 0
(E.G.: -1). <code>String::substring</code> also throws this exception when the <code>beginIndex</code> or <code>endIndex</code> argument is larger
than <code>myString.length()</code>, and <code>String::charAt</code> when the <code>index</code> argument is larger than <code>myString.length() -
1</code> For instance, it is not possible to use <code>String::charAt</code> to retrieve a value before the start or after the end of a string.
Furthermore, it is not possible to use <code>String::substring</code> with <code>beginIndex &gt; endIndex</code> to reverse the order of characters in
a string.</p>
<p>This rule raises an issue when a negative literal or an index that is too large is passed as an argument to the <code>String::substring</code>,
<code>String::charAt</code>, and related methods. It also raises an issue when the start index passed to <code>String::substring</code> is larger than
the end index.</p>
<h2>How to fix it</h2>
<p>Use non-negative indexes that are smaller than or equal to the length of the string in question with <code>String::substring</code> and strictly
smaller with <code>String::charAt</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
String speech = "Lorem ipsum dolor sit amet";

String substr1 = speech.substring(-1, speech.length()); // Noncompliant, -1 is out of bounds
String substr2 = speech.substring(speech.length(), 0);  // Noncompliant, the beginIndex must be smaller than or equal to the endIndex
char ch = speech.charAt(speech.length());               // Noncompliant, speech.length() is out of bounds
```
<h4>Compliant solution</h4>

```java
String speech = "Lorem ipsum dolor sit amet";

String substr1 = speech;                                         // Compliant, no string operation used
String substr2 = new StringBuilder(speech).reverse().toString(); // Compliant, the string can be reversed using StringBuilder::reverse()
char ch = speech.charAt(speech.length() - 1);                    // Compliant, speech.length() - 1 is in bounds.
```