<h2>Why is this an issue?</h2>
<p>In object-oriented programming, inappropriately accessing static members of a base class via derived types is considered a code smell.</p>
<p>Static members are associated with the class itself, not with any specific instance of the class or its children classes. Accessing through the
wrong type suggests a misunderstanding of the ownership and role of this member. This can make the maintenance of the code more complicated.</p>
<p>Therefore, the access should be done directly through the base class to maintain clarity and avoid potential misunderstandings.</p>
<h3>Noncompliant code example</h3>

```java
class Parent {
  public static int counter;
}

class Child extends Parent {
  public Child() {
    Child.counter++;  // Noncompliant
  }
}
```
<h3>Compliant solution</h3>

```java
class Parent {
  public static int counter;
}

class Child extends Parent {
  public Child() {
    Parent.counter++;
  }
}
```