<h2>Why is this an issue?</h2>
<p>When <code>@Overrides</code> of <code>synchronized</code> methods are not themselves <code>synchronized</code>, the result can be improper
synchronization as callers rely on the thread-safety promised by the parent class.</p>
<h3>Noncompliant code example</h3>

```java
public class Parent {

  synchronized void foo() {
    //...
  }
}

public class Child extends Parent {

 @Override
  public void foo () {  // Noncompliant
    // ...
    super.foo();
  }
}
```
<h3>Compliant solution</h3>

```java
public class Parent {

  synchronized void foo() {
    //...
  }
}

public class Child extends Parent {

  @Override
  synchronized void foo () {
    // ...
    super.foo();
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/gzdGBQ">CERT, TSM00-J</a> - Do not override thread-safe methods with methods that are not
  thread-safe </li>
</ul>