<h2>Why is this an issue?</h2>
<p>Shared naming conventions allow teams to collaborate efficiently. This rule raises an issue when a test method name does not match the provided
regular expression.</p>
<h3>Noncompliant code example</h3>
<p>With the default value: <code>^test[A-Z][a-zA-Z0-9]*$</code></p>

```java
@Test
public void foo() {  // Noncompliant
  //...
}
```
<h3>Compliant solution</h3>

```java
@Test
public void testFoo() {
  // ...
}
```