<h2>Why is this an issue?</h2>
<p>It’s a common pattern to test the result of a <code>java.util.Map.get()</code> against <code>null</code> or calling
<code>java.util.Map.containsKey()</code> before proceeding with adding or changing the value in the map. However the <code>java.util.Map</code> API
offers a significantly better alternative in the form of the <code>computeIfPresent()</code> and <code>computeIfAbsent()</code> methods. Using these
instead leads to cleaner and more readable code.</p>
<p><strong>Note</strong> that this rule is automatically disabled when the project’s <code>sonar.java.source</code> is not 8.</p>
<h3>Noncompliant code example</h3>

```java
V value = map.get(key);
if (value == null) {  // Noncompliant
  value = V.createFor(key);
  if (value != null) {
    map.put(key, value);
  }
}
if (!map.containsKey(key)) {  // Noncompliant
  value = V.createFor(key);
  if (value != null) {
    map.put(key, value);
  }
}
return value;
```
<h3>Compliant solution</h3>

```java
return map.computeIfAbsent(key, k -> V.createFor(k));
```
<h3>Exceptions</h3>
<p>This rule will not raise an issue when trying to add <code>null</code> to a map, because <code>computeIfAbsent</code> will not add the entry if the
value returned by the function is <code>null</code>.</p>
<h2>Resources</h2>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S6104'>java:S6104</a> - Map "computeIfAbsent()" and "computeIfPresent()" should not be used to add "null" values. </li>
</ul>