<h2>Why is this an issue?</h2>
<p>If a string fits on a single line, without concatenation and escaped newlines, you should probably continue to use a string literal.</p>
<h3>Noncompliant code example</h3>

```java
String question = """
              What's the point, really?""";
```
<h3>Compliant solution</h3>

```java
String question = "What's the point, really?";
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://openjdk.java.net/jeps/378">JEP 378: Text Blocks</a> </li>
  <li> <a href="https://openjdk.org/projects/amber/guides/text-blocks-guide">Programmer’s Guide To Text Blocks</a>, by Jim Laskey and Stuart Marks
  </li>
</ul>