<h2>Why is this an issue?</h2>
<p>The use of escape sequences is mostly unnecessary in text blocks.</p>
<h3>Noncompliant code example</h3>
<p><code>\n</code> can be replaced by simply introducing the newline, <code>\"\"\"</code> it is sufficient to escape only the first qoute.</p>

```java
String textBlock = """
        \"\"\" this \nis
        text  block!
        !!!!
      """;
```
<h3>Compliant solution</h3>

```java
String textBlock = """
        \""" this
        is
        text  block!
        !!!!
      """;
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://openjdk.java.net/jeps/378">JEP 378: Text Blocks</a> </li>
  <li> <a href="https://openjdk.org/projects/amber/guides/text-blocks-guide">Programmer’s Guide To Text Blocks</a>, by Jim Laskey and Stuart Marks
  </li>
</ul>