<p>This rule raises an issue when multiple branches of a regex alternative match the same input.</p>
<h2>Why is this an issue?</h2>
<p>If an alternative in a regular expression only matches things that are already matched by another alternative, that alternative is redundant and
serves no purpose.</p>
<p>In the best case this means that the offending subpattern is merely redundant and should be removed. In the worst case it’s a sign that this regex
does not match what it was intended to match and should be reworked.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
"[ab]|a"   // Noncompliant: the "|a" is redundant because "[ab]" already matches "a"
".*|a"     // Noncompliant: .* matches everything, so any other alternative is redundant
```
<h4>Compliant solution</h4>

```java
"[ab]"
".*"
```