<h2>Why is this an issue?</h2>
<p>If the credentials provider is not specified when creating a new AwsClient with an <a
href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/awscore/client/builder/AwsClientBuilder.html">AwsClientBuilder</a>, the AWS SDK
will execute some logic to identify it automatically.</p>
<p>While it will probably identify the correct one, this extra logic will slow down startup time, already known to be a hotspot.</p>
<p>You should therefore always define the logic to set the credentials provider yourself. This is typically done by retrieving it from the Lambda
provided environment variable.</p>
<p>This will make the code more explicit and spare initialization time.</p>
<p>This rule reports an issue when the credentials provider is not set when creating an AwsClient.</p>
<h3>Noncompliant code example</h3>

```java
S3Client.builder()
    .region(Region.of(System.getenv(SdkSystemSetting.AWS_REGION.environmentVariable())))
    .build();
```
<h3>Compliant solution</h3>

```java
S3Client.builder()
    .region(Region.of(System.getenv(SdkSystemSetting.AWS_REGION.environmentVariable()))
    .credentialsProvider(EnvironmentVariableCredentialsProvider.create())
    .build();
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://aws.amazon.com/fr/blogs/developer/tuning-the-aws-java-sdk-2-x-to-reduce-startup-time/">Tuning the AWS Java SDK 2.x to reduce
  startup time</a> </li>
  <li> <a href="https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/lambda-optimize-starttime.html">Optimizing cold start performance for
  AWS Lambda</a> </li>
  <li> <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html">Environment variable configuration</a> </li>
  <li> <a href="https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/credentials.html">Default Credential Provider Chain</a> </li>
</ul>