<h2>Why is this an issue?</h2>
<p>Using the same value on both sides of a binary operator is a code defect. In the case of logical operators, it is either a copy/paste error and,
therefore, a bug, or it is simply duplicated code and should be simplified. In the case of bitwise operators and most binary mathematical operators,
having the same value on both sides of an operator yields predictable results and should be simplified as well.</p>
<h3>Noncompliant code example</h3>

```js
if (a == b && a == b) { // if the first one is true, the second one is too
  doX();
}
if (a > a) { // always false
  doW();
}

var j = 5 / 5; //always 1
var k = 5 - 5; //always 0
```
<h3>Exceptions</h3>
<p>The specific case of testing one variable against itself is a valid test for <code>NaN</code> and is therefore ignored.</p>
<p>Similarly, left-shifting 1 onto 1 is common in the construction of bit masks, and is ignored.</p>
<p>Moreover comma operator <code>,</code> and <code>instanceof</code> operator are ignored as there are use-cases when there usage is valid.</p>

```js
if (f !== f) { // test for NaN value
  console.log("f is NaN");
}

var i = 1 << 1; // Compliant
var j = a << a; // Noncompliant
```
<h2>Resources</h2>
<ul>
  <li> <a href='checks/checks/?languages=JAVASCRIPT&tools=SONAR_LINT&rule=javascript:S1656'>javascript:S1656</a> - Implements a check on <code>=</code>. </li>
</ul>