<h2>Why is this an issue?</h2>
<p>On the principle that clearer code is better code, you should explicitly <code>import</code> the things you want to use in a module. Using
<code>import *</code> imports everything in the module and risks confusing maintainers. Similarly, <code>export * from "module";</code> imports and
then re-exports everything in the module and risks confusing not just maintainers but also the module’s users.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
import * as Imported from "aModule";  // Noncompliant
```
<h4>Compliant solution</h4>

```js
import {aType, aFunction} from "aModule";
```