<h2>Why is this an issue?</h2>
<p>Object literal syntax, which initializes an object’s properties inside the object declaration is cleaner and clearer than the alternative: creating
an empty object, and then giving it properties one by one.</p>
<p>An issue is raised when the following pattern is met:</p>
<ul>
  <li> An empty object is created. </li>
  <li> A consecutive single-line statement adds a property to the created object. </li>
</ul>
<h3>Noncompliant code example</h3>

```js
let person = {};  // Noncompliant
person.firstName = "John";
person.middleInitial = "Q";
person.lastName = "Public";
```
<h3>Compliant solution</h3>

```js
let person = {
  firstName: "John",
  middleInitial: "Q",
  lastName: "Public",
}
```