<h2>Why is this an issue?</h2>
<p>Having inconsistent indentation and omitting curly braces from a control structure, such as an <code>if</code> statement or <code>for</code> loop,
is misleading and can induce bugs.</p>
<p>This rule raises an issue when the indentation of the lines after a control structure indicates an intent to include those lines in the block, but
the omission of curly braces means the lines will be unconditionally executed once.</p>
<p>The following patterns are recognized:</p>

```js
if (condition)
  firstActionInBlock();
  secondAction();  // Noncompliant: secondAction is executed unconditionally
thirdAction();
```

```js
if (condition) firstActionInBlock(); secondAction();  // Noncompliant: secondAction is executed unconditionally
```

```js
if (condition) firstActionInBlock();  // Noncompliant
  secondAction();  // Executed unconditionally
```

```js
if (condition); secondAction();  // Noncompliant: secondAction is executed unconditionally
```

```js
let str = undefined;
for (let i = 0; i < array.length; i++)
  str = array[i];
  doTheThing(str);  // Noncompliant: executed only on the last element
```
<p>Note that this rule considers tab characters to be equivalent to 1 space. When mixing spaces and tabs, a code may look fine in one editor but be
confusing in another configured differently.</p>
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/483">CWE-483 - Incorrect Block Delimitation</a> </li>
</ul>