<h2>Why is this an issue?</h2>
<p>The result of an expression with an arithmetic operator <code>/, *, %, ++, --, -, +=, -=, *=, /=, %=, +</code> or unary operator <code>+, -</code>
when at least one operand is <code>Object</code> or <code>Undefined</code> will be always a <code>NaN</code> (Not a Number).</p>
<h3>Noncompliant code example</h3>

```js
x = [1, 2];
var y = x / 4;  //Noncompliant
```
<h3>Exceptions</h3>
<ul>
  <li> <code>Date</code> operands: they are implicitly converted to numbers. </li>
  <li> The binary <code>+</code> operator with <code>Object</code> operand (concatenation). </li>
</ul>