<h2>Why is this an issue?</h2>
<p>Unlike strongly typed languages, JavaScript does not enforce a return type on a function. This means that different paths through a function can
return different types of values.</p>
<p>Returning different types from a function can make the code less readable and harder to understand. Maintainers may have to spend more time
figuring out how the function works and what it returns. Additionally, it can be harder to ensure that the code is free of type-related errors.</p>

```js
function foo(a) {  // Noncompliant: function returns 'boolean' or 'number'
  if (a === 1) {
    return true;
  }
  return 3;
}
```
<p>Rework the function so that it always returns the same type. This makes the code more consistent and easier to understand. Maintainers can rely on
the function to behave in a predictable way.</p>

```js
function foo(a) {
  if (a === 1) {
    return true;
  }
  return false;
}
```
<h3>Exceptions</h3>
<ul>
  <li> Functions returning <code>this</code> are ignored. </li>
</ul>

```js
function foo() {
  // ...
  return this;
}
```
<ul>
  <li> Functions returning expressions having type <code>any</code> are ignored. </li>
</ul>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/return"><code>return</code></a> </li>
</ul>