<h2>Why is this an issue?</h2>
<p>When a non-existent variable is referenced a <code>ReferenceError</code> is raised.</p>
<p>Due to the dynamic nature of JavaScript this can happen in a number of scenarios:</p>
<ul>
  <li> When typo was made in a symbol’s name. </li>
  <li> When using variable declared with <code>let</code> or <code>const</code> before declaration (unlike <code>var</code>-declarations, they are not
  hoisted to the top of the scope). </li>
  <li> Due to confusion with scopes of <code>let</code>- and <code>const</code>-declarations (they have block scope, unlike
  <code>var</code>-declarations, having function scope). </li>
  <li> When accessing a property in the wrong scope (e.g. forgetting to specify <code>this.</code>). </li>
</ul>
<p>This rule does not raise issues on global variables which are defined with <code>sonar.javascript.globals</code> and
<code>sonar.javascript.environments</code> properties.</p>
<h3>Noncompliant code example</h3>

```js
var john = {
  firstName: "john",
  show: function() { console.log(firstName); } // Noncompliant: firstName is not defined
}
john.show();
```
<h3>Compliant solution</h3>

```js
var john = {
  firstName: "john",
  show: function() { console.log(this.firstName); }
}
john.show();
```