<h2>Why is this an issue?</h2>
<p>JSX lets you write HTML-like markup inside a JavaScript file, commonly used in React.</p>
<p>Adding comments inside JSX might be tricky as JSX code is neither a plain HTML nor JavaScript.</p>
<p>HTML comments (<code>&lt;!-- comment here --&gt;</code>) are not valid syntax in JSX.</p>
<p>JavaScript-style comments, single or multiline, will create an additional text node in the browser, which is probably not expected.</p>

```js
<div>
  // Noncompliant: text inside node
</div>
```
<p>To avoid that, use JavaScript multiline comments enclosed in curly braces. Single-line comments can also be used, but avoid having the ending
bracket in the same line.</p>

```js
<div>
  {
    /*
      multi-line
      comment
    */
  }
  {
    // single-line comment
  }
  { /* short form comment */ }
</div>
```
<p>Note that JavaScript comments around attributes are also allowed (<code>&lt;div /* comment */&gt;</code>).</p>
<p>If the additional text node is intentional, prefer using a JavaScript string literal containing that comment.</p>

```js
<div>
  { '// text inside node' }
</div>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn/javascript-in-jsx-with-curly-braces">JavaScript in JSX with Curly Braces</a> </li>
</ul>