<p>Comparisons that always evaluate to true or to false, logical expressions that either always or never short-circuit and comparisons to a newly
constructed object should not be used.</p>
<h2>Why is this an issue?</h2>
<p>An expression that always produces the same result, regardless of the inputs, is unnecessary and likely indicates a programmer’s error. This can
come from</p>
<ul>
  <li> confusing operator precedence </li>
  <li> expecting strict equality between different types </li>
  <li> expecting objects to be compared by value </li>
  <li> expecting empty objects to be <code>false</code> or <code>null</code> </li>
  <li> mistyping <code>&gt;=</code> for <code>⇒</code> </li>
</ul>
<p>This can also happen when you put an assignment in a logical sub-expression. While not strictly a bug, this practice is confusing and should be
avoided.</p>
<h2>How to fix it</h2>
<p>Review the code around the issue to find out why the expression always produces the same result. Pay attention to the operator precedence,
comparing objects of different types, and comparing objects by reference (not by value!).</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
!foo == null;
a + b ?? c;
x === [];
(foo=0) && bar;
```
<h4>Compliant solution</h4>

```js
foo != null;
a + (b ?? c);
x.length === 0;
```