<h2>Why is this an issue?</h2>
<p>Initializing a variable to <code>undefined</code> is unnecessary and should be avoided. A variable will automatically be set to
<code>undefined</code> if you declare it without initialization, so the initialization code is redundant in this case.</p>

```js
var foo = undefined; // Noncompliant: replace with var foo;
let bar = undefined; // Noncompliant: replace with let foo;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/undefined"><code>undefined</code></a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/let"><code>let</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var"><code>var</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Hoisting">hoisting</a> </li>
</ul>