<h2>Why is this an issue?</h2>
<p>Renaming imports, exports, or destructuring assignments to the same name is redundant and can be safely removed. You may accidentally end up with
such code if you do a refactoring and change the local name in several places.</p>

```js
import { foo as foo } from "bar";
export { foo as foo };
let { foo: foo } = bar;
```
<p>Fix your code to remove the unnecessary renaming.</p>

```js
import { foo } from "bar";
export { foo };
let { foo } = bar;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/import">import</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/export">export</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Destructuring_assignment">Destructuring
  assignment</a> </li>
</ul>