<h2>Why is this an issue?</h2>
<p>The PSR2 standard recommends listing modifiers in the following order to improve the readability of PHP source code:</p>
<ol>
  <li> final or abstract </li>
  <li> public or protected or private </li>
  <li> static </li>
</ol>
<h3>Noncompliant code example</h3>

```php
static protected $foo;
...
public static final function bar(){...}
```
<h3>Compliant solution</h3>

```php
protected static $foo;
...
final public static function bar(){...}
```