<h2>Why is this an issue?</h2>
<p>There is no need to use the <code>final</code> modifier inside a <code>final</code> class. Everything in it is <code>final</code> by default.</p>
<h3>Noncompliant code example</h3>

```php
final class MyClass {

  public final String getName() {  // Noncompliant
    return name;
  }
}
```
<h3>Compliant solution</h3>

```php
final class MyClass {

  public String getName() {  // Compliant
    return name;
  }
}
```