<h2>Why is this an issue?</h2>
<p><code>ini_set</code> changes the value of the given configuration option for the duration of the script’s execution. While there may be a reason to
do this, you should make sure that it’s a very good reason indeed, because this is the sort of "magic" change which can cause severe teeth-gnashing
and hair tearing when the script needs to be debugged.</p>
<p>For instance, if the user explicitly turns logging on for a script, but then the script itself uses <code>ini_set('display_errors', 0);</code> to
turn logging back off, it is likely that every other aspect of the environment will be examined before, in desperation, the script is read to figure
out where the logging is going.</p>
<h3>Noncompliant code example</h3>

```php
ini_set('display_errors', 0);  // Noncompliant
```