<h2>Why is this an issue?</h2>
<p>Nested ternaries are hard to read and can make the order of operations complex to understand.</p>

```php
function get_readable_status($is_running, $has_errors) {
  return $is_running ? "Running" : ($has_errors ? "Failure" : "Succeeded");  // Noncompliant
}
```
<p>Instead, use another line to express the nested operation in a separate statement.</p>

```php
function get_readable_status($is_running, $has_errors) {
  if ($is_running) {
    return "Running";
  }
  return $has_errors ? "Failure. " : "Succeeded ";
}
```
<h3>Exceptions</h3>
<p>Exclusively chained shorthand ternary operators <code>?:</code> are excluded from this rule.</p>

```php
$result = $option1 ?: $option2 ?: 'default'; // Compliant by exception
```