<h2>Why is this an issue?</h2>
<p>Namespaces should be preferred over the <code>include</code> or <code>require</code> functions in PHP because they provide a cleaner and more
organized approach for managing code dependencies. Namespaces allow you to logically group related classes, functions, and constants, preventing
naming conflicts and improving code readability. They also promote code reusability by enabling modularization and encapsulation. On the other hand,
using <code>include</code> or <code>require</code> functions directly can lead to a cluttered global namespace and make it harder to track and manage
dependencies, especially in larger projects.</p>
<h3>Exceptions</h3>
<p>This rule doesn’t raise issues on <code>autoload.php</code> files. This file is typically generated by Composer that provides an autoloading
mechanism for classes and functions. Composer is a dependency management tool for PHP that simplifies the process of integrating external libraries
and packages into your project.</p>
<h2>How to fix it</h2>
<p>It is recommended to use the PSR-4 autoloading standard and to use Composer to manage the loading of classes and functions.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
require_once './shop/modules/vegetable/src/entity/Tomato.php';
```
<h4>Compliant solution</h4>

```php
use Shop\Vegetable\Tomato
```
<h3>How does this work?</h3>
<p>To import classes and functions with namespaces using Composer in PHP you have to ensure that the project is set up to use Composer and have a
valid composer.json file in the root directory. Make sure the namespace corresponds to the directory structure of your classes.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php-fig.org/psr/psr-4/">PSR-4: Autoloader</a> </li>
  <li> <a href="https://getcomposer.org/doc/00-intro.md">Composer - PHP Dependency Management</a> </li>
</ul>