<h2>Why is this an issue?</h2>
<p>Offering the same experience with the mouse and the keyboard allow users to pick their preferred devices.</p>
<p>Additionally, users of assistive technology will also be able to browse the site even if they cannot use the mouse.</p>
<p>This rules detects the following issues:</p>
<ul>
  <li> when <code>onClick</code> is not accompanied by at least one of the following: <code>onKeyUp</code>, <code>onKeyDown</code>,
  <code>onKeyPress</code>. </li>
  <li> when <code>onmouseover</code>/<code>onmouseout</code> are not paired by <code>onfocus</code>/<code>onblur</code>. </li>
</ul>
<h2>How to fix it in JSX</h2>
<p>Add at least one of the following event handlers <code>onKeyUp</code>, <code>onKeyDown</code>, <code>onKeyPress</code> to the element when using
<code>onClick</code> event handler. Add corresponding event handlers <code>onfocus</code>/<code>onblur</code> to the element when using
<code>onmouseover</code>/<code>onmouseout</code> event handlers.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
<div onClick={() => {}} />

<div onMouseOver={ () => {}} }  />
```
<h4>Compliant solution</h4>

```ts
<div onClick={() => {}} onKeyDown={this.handleKeyDown} />

<div onMouseOver={ () => {} } onFocus={ () => {} } />
```
<h2>Exceptions</h2>
<p>This does not apply for interactive or hidden elements, eg. when using <code>aria-hidden="true"</code> attribute.</p>
<h2>Resources</h2>
<ul>
  <li> SCR2 - <a href="https://www.w3.org/TR/WCAG20-TECHS/SCR2.html">Using redundant keyboard and mouse event handlers</a> </li>
  <li> G90 - <a href="https://www.w3.org/TR/WCAG20-TECHS/G90.html">Providing keyboard-triggered event handlers</a> </li>
</ul>