<p>This rule is deprecated, and will eventually be removed.</p>
<h2>Why is this an issue?</h2>
<p>Shared naming conventions allow teams to collaborate effectively. This rule raises an issue when the brace-style is not respecting the convention
setup in parameter:</p>
<ul>
  <li> <a href="https://en.wikipedia.org/wiki/Indentation_style#K&amp;R_style">1tbs</a> (default) </li>
  <li> <a href="https://en.wikipedia.org/wiki/Indentation_style#Allman_style">allman</a> </li>
  <li> <a href="https://en.wikipedia.org/wiki/Indentation_style#Variant:_Stroustrup">stroustrup</a> </li>
</ul>
<h3>Noncompliant code example</h3>
<p>Using the parameter default (1tbs):</p>

```ts
if (condition)
{                                                      //Noncompliant
  doSomething();
}                                                      //Noncompliant
else {
  doSomethingElse();
}
```
<h3>Compliant solution</h3>

```ts
if (condition) {                                   //Compliant
  doSomething();
} else {                                           //Compliant
  doSomethingElse();
}
```
<h3>Exceptions</h3>
<ul>
  <li> Object literals appearing as arguments can start on their own line. </li>
</ul>

```ts
functionWithObject(
   {                                                 //Compliant
        g: "someValue"
   }
);
```
<ul>
  <li> When blocks are inlined (left and right curly braces on the same line), no issue is triggered. </li>
</ul>

```ts
if(condition) {doSomething();}                       //Compliant
```